package view.gui;

import model.AUnit;
import view.IView;
import view.TempCalcFrame;

import javax.swing.*;
import java.awt.*;

/**
 * Standard view of the conversion calculator.
 *
 * @author Mathias Ricken
 */
public class StandardView extends JPanel implements IView {
    /**
     * Frame for this view.
     */
    private TempCalcFrame _frame;

    /**
     * List model with different units.
     */
    private DefaultListModel _unitListModel;

    /**
     * Constructs a new gui conversion calculator view.
     *
     * @param units list of units
     */
    public StandardView(java.util.List<AUnit> units) {
        _unitListModel = new DefaultListModel();
        for(AUnit u : units) {
            _unitListModel.addElement(u);
        }
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Run the calculator.
     */
    public void run() {
        _frame.setVisible(true);
    }
    
    /**
     * Initialize the GUI components.
     */
    private void jbInit() {
        setSize(new Dimension(540, 380));
        setLayout(new BorderLayout());
        // create a listbox that containing the units passed to the constructor
        JList _unitList = new JList(_unitListModel);

        //
        // TODO: create GUI
        // NOTE: you should add _unitList to a panel to display it; right now, it's invisible
        //

        // and create a TempCalcFrame containing this panel that doesn't exit on close
        _frame = new TempCalcFrame(this, false);
    }

    //
    // TODO: add methods
    //
}
